SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

-- --------------------------------------------------------

--
-- Table structure for table `administrators`
--

CREATE TABLE IF NOT EXISTS `administrators` (
  `ADMINID` bigint(20) NOT NULL auto_increment,
  `email` varchar(80) NOT NULL default '',
  `username` varchar(80) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`ADMINID`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `administrators`
--

INSERT INTO `administrators` (`ADMINID`, `email`, `username`, `password`) VALUES
(1, 'webmaster@idocscript.com', 'Admin', '6711af8dea3d9786b9e44aa4de97b942');

-- --------------------------------------------------------

--
-- Table structure for table `advertisements`
--

CREATE TABLE IF NOT EXISTS `advertisements` (
  `AID` bigint(30) NOT NULL auto_increment,
  `description` varchar(200) NOT NULL default '',
  `code` text NOT NULL,
  `active` enum('1','0') NOT NULL default '1',
  PRIMARY KEY  (`AID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `advertisements`
--

INSERT INTO `advertisements` (`AID`, `description`, `code`, `active`) VALUES
(1, '300 x 250 pixels', '<div style="width:300px; height:250px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your<br/>Advertisement Here</div>', '1'),
(2, '120 x 728 pixels', '<div style="width:120px; height:728px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>', '1'),
(3, '728 x 90 pixels', '<div style="width:728px; height:90px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>', '1'),
(4, '350 x 90 pixels', '<div style="width:350px; height:90px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>', '1'),
(5, '300 x 100 pixels', '<div style="width:300px; height:100px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>', '1'),
(6, '200 x 728 pixels', '<div style="width:200px; height:728px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>', '1');

-- --------------------------------------------------------

--
-- Table structure for table `categories_docs`
--

CREATE TABLE IF NOT EXISTS `categories_docs` (
  `CATID` bigint(20) NOT NULL auto_increment,
  `name` varchar(120) NOT NULL default '',
  `details` varchar(200) NOT NULL default '',
  `extension` varchar(5) NOT NULL default '',
  `featured` char(1) NOT NULL default '0',
  PRIMARY KEY  (`CATID`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `categories_docs`
--

INSERT INTO `categories_docs` (`CATID`, `name`, `details`, `extension`, `featured`) VALUES
(1, 'Art & Culture', 'Art & Culture', '.png', '1'),
(2, 'Autos & Vehicles', 'Autos & Vehicles', '.png', '1'),
(3, 'Business', 'Business', '.png', '1'),
(4, 'Finance', 'Finance', '.png', '1'),
(5, 'Entertainment', 'Entertainment', '.png', '0'),
(6, 'Internet', 'Internet', '.png', '1'),
(7, 'Lifestyle', 'Lifestyle', '.png', '1'),
(8, 'Real Estate', 'Real Estate', '.png', '0'),
(9, 'Shopping', 'Shopping', '.png', '0'),
(10, 'Travel', 'Travel', '.png', '0');

-- --------------------------------------------------------

--
-- Table structure for table `config`
--

CREATE TABLE IF NOT EXISTS `config` (
  `setting` varchar(60) NOT NULL default '',
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `config`
--

INSERT INTO `config` (`setting`, `value`) VALUES
('site_email', 'webmaster@yourdomain.com'),
('site_name', 'iDocScript - Document Sharing Script'),
('max_syndicate_results', '25'),
('maximum_results', '1000000'),
('emailsender', 'Admin'),
('max_img_size', '200'),
('max_thumb_width', '124'),
('max_thumb_height', '93'),
('max_display_size', '400'),
('items_per_page', '18'),
('max_doc_size', '300000000'),
('rel_doc_per_page', '2'),
('recently_viewed_doc', '12'),
('who_can_download', '0'),
('allow_downloads', '1'),
('max_recent_main', '20'),
('max_feat', '10'),
('seo_title_include', '.html'),
('only_vote_once', '1'),
('approve_docs', '0'),
('max_new_docs_pv', '8'),
('max_related_docs_pv', '4'),
('max_user_docs_pv', '8'),
('metadescription', 'iDocScript Document Sharing Script - Share your documents with the world'),
('metakeywords', 'document,sharing,script,iDocScript'),
('editors_pick', '18'),
('max_com_doc', '1000'),
('max_com_profile', '1000'),
('max_pop_home', '4'),
('enable_captcha', '1'),
('verify_upload', '1'),
('max_feat_home', '6'),
('ver', '2.3'),
('man_mem_val', '0');

-- --------------------------------------------------------

--
-- Table structure for table `docs`
--

CREATE TABLE IF NOT EXISTS `docs` (
  `DID` bigint(20) NOT NULL auto_increment,
  `USERID` bigint(20) NOT NULL default '0',
  `title` varchar(120) NOT NULL default '',
  `description` text NOT NULL,
  `tags` text NOT NULL,
  `categories` varchar(255) NOT NULL default '0|',
  `original_doc` varchar(50) NOT NULL default '',
  `doc_name` varchar(50) default NULL,
  `filesize` bigint(20) NOT NULL default '0',
  `public` char(1) NOT NULL default '1',
  `time_added` varchar(20) default NULL,
  `date_added` date NOT NULL default '0000-00-00',
  `viewcount` bigint(10) NOT NULL default '0',
  `last_viewed` datetime NOT NULL default '0000-00-00 00:00:00',
  `commentcount` int(8) NOT NULL default '0',
  `favoritecount` int(8) NOT NULL default '0',
  `downloadcount` int(8) NOT NULL default '0',
  `featured` char(1) NOT NULL default '0',
  `ratingcount` bigint(10) NOT NULL default '0',
  `rating` float NOT NULL default '0',
  `filehome` varchar(120) NOT NULL default '',
  `allowcomments` char(1) NOT NULL default '1',
  `allowratings` char(1) NOT NULL default '1',
  `allowembeds` char(1) NOT NULL default '1',
  `allowdownloads` char(1) NOT NULL default '1',
  `voter_id` varchar(200) NOT NULL default '',
  `active` char(1) NOT NULL default '',
  `mature` char(1) NOT NULL default '0',
  PRIMARY KEY  (`DID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `docs_comments`
--

CREATE TABLE IF NOT EXISTS `docs_comments` (
  `CID` bigint(20) NOT NULL auto_increment,
  `DID` bigint(20) NOT NULL default '0',
  `USERID` bigint(20) NOT NULL default '0',
  `details` text NOT NULL,
  `time_added` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`CID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `docs_favorited`
--

CREATE TABLE IF NOT EXISTS `docs_favorited` (
  `FID` bigint(20) NOT NULL auto_increment,
  `USERID` bigint(25) NOT NULL default '0',
  `DID` bigint(25) NOT NULL default '0',
  PRIMARY KEY  (`FID`),
  UNIQUE KEY `USERID` (`USERID`,`DID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `docs_reports`
--

CREATE TABLE IF NOT EXISTS `docs_reports` (
  `RID` bigint(20) NOT NULL auto_increment,
  `USERID` bigint(20) NOT NULL default '0',
  `DID` bigint(20) NOT NULL default '0',
  `reason` varchar(100) NOT NULL default '',
  `remarks` text NOT NULL,
  `date` date NOT NULL default '0000-00-00',
  `time` varchar(20) default NULL,
  PRIMARY KEY  (`RID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `friends`
--

CREATE TABLE IF NOT EXISTS `friends` (
  `FID` bigint(20) NOT NULL auto_increment,
  `USERID` bigint(20) NOT NULL default '0',
  `FRIENDID` bigint(20) NOT NULL default '0',
  `time_added` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`FID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

--
-- Table structure for table `friends_requests`
--

CREATE TABLE IF NOT EXISTS `friends_requests` (
  `RID` bigint(20) NOT NULL auto_increment,
  `REQUESTER` bigint(20) NOT NULL default '0',
  `REQUESTEE` bigint(20) NOT NULL default '0',
  `message` varchar(200) NOT NULL default '',
  `time` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`RID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

--
-- Table structure for table `members`
--

CREATE TABLE IF NOT EXISTS `members` (
  `USERID` bigint(20) NOT NULL auto_increment,
  `email` varchar(80) NOT NULL default '',
  `username` varchar(80) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `firstname` varchar(60) NOT NULL default '',
  `lastname` varchar(60) NOT NULL default '',
  `birthday` date NOT NULL default '0000-00-00',
  `gender` varchar(6) NOT NULL default '',
  `description` text NOT NULL,
  `url` varchar(150) NOT NULL default '',
  `city` varchar(80) NOT NULL default '',
  `country` varchar(100) NOT NULL default '',
  `yourdocsviewed` int(15) NOT NULL default '0',
  `profileviews` int(20) NOT NULL default '0',
  `docsyouviewed` int(15) NOT NULL default '0',
  `addtime` varchar(20) NOT NULL default '',
  `lastlogin` varchar(20) NOT NULL default '',
  `verified` char(1) NOT NULL default '0',
  `status` enum('1','0') NOT NULL default '1',
  `voter_id` varchar(200) NOT NULL default '',
  `ratingcount` bigint(10) NOT NULL default '0',
  `rating` float NOT NULL default '0',
  `profilepicture` varchar(100) NOT NULL default '',
  `familyfilter` char(1) NOT NULL default '1',
  `avatar` varchar(200) NOT NULL default 'noavatar.gif',
  `customavatar` char(1) NOT NULL default '0',
  `bgimage` varchar(100) NOT NULL default '',
  `featured` char(1) NOT NULL default '0',
  `remember_me_key` varchar(32) default NULL,
  `remember_me_time` datetime default NULL,
  PRIMARY KEY  (`USERID`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `members_comments`
--

CREATE TABLE IF NOT EXISTS `members_comments` (
  `CID` bigint(20) NOT NULL auto_increment,
  `PROFILEID` bigint(20) NOT NULL default '0',
  `USERID` bigint(20) NOT NULL default '0',
  `details` text NOT NULL,
  `time_added` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`CID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `members_passcode`
--

CREATE TABLE IF NOT EXISTS `members_passcode` (
  `USERID` bigint(20) NOT NULL default '0',
  `code` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`USERID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- --------------------------------------------------------

--
-- Table structure for table `members_subscribers`
--

CREATE TABLE IF NOT EXISTS `members_subscribers` (
  `SID` int(8) NOT NULL auto_increment,
  `subscriber` varchar(20) NOT NULL default '',
  `subscribee` varchar(20) NOT NULL default '',
  UNIQUE KEY `SID` (`SID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `members_verifycode`
--

CREATE TABLE IF NOT EXISTS `members_verifycode` (
  `USERID` bigint(20) NOT NULL default '0',
  `code` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`USERID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `search_phrases`
--

CREATE TABLE IF NOT EXISTS `search_phrases` (
  `SID` bigint(20) NOT NULL auto_increment,
  `type` varchar(10) NOT NULL default '',
  `phrase` varchar(100) NOT NULL default '',
  `searchcount` bigint(30) NOT NULL default '1',
  PRIMARY KEY  (`SID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sendmail`
--

CREATE TABLE IF NOT EXISTS `sendmail` (
  `EID` varchar(50) NOT NULL default '',
  `subject` varchar(255) NOT NULL default '',
  `template` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`EID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sendmail`
--

INSERT INTO `sendmail` (`EID`, `subject`, `template`) VALUES
('confirmemail', 'E-Mail Verification', 'sendmail/confirmemail.tpl'),
('sendnewpassword', 'Your new password for', 'sendmail/sendnewpassword.tpl'),
('welcomeemail', 'Welcome to', 'sendmail/welcomeemail.tpl'),
('forgotusername', 'Forgot Username', 'sendmail/forgotusername.tpl'),
('newmessage', 'New message from', 'sendmail/newmessage.tpl'),
('sharedoc', 'wants you to see this document!', 'sendmail/sharedoc.tpl'),
('confirmforgotpass', 'Reset Password Link', 'sendmail/confirmforgotpass.tpl');

-- --------------------------------------------------------

--
-- Table structure for table `static`
--

CREATE TABLE IF NOT EXISTS `static` (
  `ID` bigint(30) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `value` blob NOT NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `static`
--

INSERT INTO `static` (`ID`, `title`, `value`) VALUES
(1, 'Terms Of Use', 0x496e7365727420796f7572207465726d73206f662075736520696e666f726d6174696f6e20686572652e3c62723e3c62723e0d0a0d0a48544d4c2069732061636365707465642e),
(2, 'Privacy Policy', 0x496e7365727420796f7572207072697661637920706f6c69637920696e666f726d6174696f6e20686572652e3c62723e3c62723e0d0a0d0a48544d4c2069732061636365707465642e),
(3, 'About Us', 0x496e7365727420796f75722061626f757420757320696e666f726d6174696f6e20686572652e3c62723e3c62723e0d0a0d0a48544d4c2069732061636365707465642e),
(4, 'Advertising', 0x496e7365727420796f7572206164766572746973696e6720696e666f726d6174696f6e20686572652e3c62723e3c62723e0d0a0d0a48544d4c2069732061636365707465642e),
(5, 'Contact Us', 0x496e7365727420796f757220636f6e7461637420757320696e666f726d6174696f6e20686572652e3c62723e3c62723e0d0a0d0a48544d4c2069732061636365707465642e);

INSERT INTO `config` (`setting` ,`value`) VALUES ('max_rc', '10');
UPDATE `advertisements` SET `code` = '<div style="width:468px; height:60px; border:1px solid #DFDFDF;" align="center"><br>Insert Your Advertisement Here</div>' WHERE `advertisements`.`AID` =1;
UPDATE `advertisements` SET `description` = '125 x 125 pixels #1',
`code` = '<div style="width:125px; height:125px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>' WHERE `advertisements`.`AID` =2;
UPDATE `advertisements` SET `description` = '125 x 125 pixels #2',
`code` = '<div style="width:125px; height:125px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>' WHERE `advertisements`.`AID` =3;
UPDATE `advertisements` SET `description` = '125 x 125 pixels #3',
`code` = '<div style="width:125px; height:125px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>' WHERE `advertisements`.`AID` =4;
UPDATE `advertisements` SET `description` = '125 x 125 pixels #4',
`code` = '<div style="width:125px; height:125px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>' WHERE `advertisements`.`AID` =5;
UPDATE `advertisements` SET `description` = '728 x 90 pixels',
`code` = '<div style="width:728px; height:90px; border:1px solid #DFDFDF;" align="center"><br/><br/>Insert Your Advertisement Here</div>' WHERE `advertisements`.`AID` =6;
INSERT INTO `advertisements` (`AID`, `description`, `code`, `active`) VALUES (NULL, '300 x 300 pixels', '<div style="width:300px; height:300px; border:1px solid #DFDFDF;" align="center"><br><br>Insert Your Advertisement Here</div>', '1');
INSERT INTO `config` (`setting` ,`value`)VALUES ('max_nd_home', '4');

CREATE TABLE IF NOT EXISTS `bans_ips` (
  `ip` varchar(20) NOT NULL,
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE `members` ADD `ip` VARCHAR( 20 ) NOT NULL ;
ALTER TABLE `members` ADD `lip` VARCHAR( 20 ) NOT NULL ;